/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChunkStatus
extends ForgeRegistryEntry<ChunkStatus> {
    public static final int f_187758_ = 8;
    private static final EnumSet<Heightmap.Types> f_62327_ = EnumSet.of(Heightmap.Types.OCEAN_FLOOR_WG, Heightmap.Types.WORLD_SURFACE_WG);
    public static final EnumSet<Heightmap.Types> f_62328_ = EnumSet.of(Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    private static final LoadingTask f_62329_ = (p_62461_, p_62462_, p_62463_, p_62464_, p_62465_, p_62466_) -> {
        if (p_62466_ instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)p_62466_;
            if (!p_62466_.m_6415_().m_62427_(p_62461_)) {
                protochunk.m_7150_(p_62461_);
            }
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_62466_));
    };
    public static final ChunkStatus f_62314_ = ChunkStatus.m_62414_("empty", null, -1, f_62327_, ChunkType.PROTOCHUNK, (p_156307_, p_156308_, p_156309_, p_156310_, p_156311_) -> {});
    public static final ChunkStatus f_62315_ = ChunkStatus.m_62406_("structure_starts", f_62314_, 0, f_62327_, ChunkType.PROTOCHUNK, (p_187861_, p_187862_, p_187863_, p_187864_, p_187865_, p_187866_, p_187867_, p_187868_, p_187869_, p_187870_) -> {
        if (!p_187869_.m_6415_().m_62427_(p_187861_)) {
            if (p_187863_.m_142572_().m_129910_().m_5961_().m_64657_()) {
                p_187864_.m_62199_(p_187863_.m_5962_(), p_187863_.m_8595_(), p_187869_, p_187865_, p_187863_.m_7328_());
            }
            if (p_187869_ instanceof ProtoChunk) {
                ProtoChunk protochunk = (ProtoChunk)p_187869_;
                protochunk.m_7150_(p_187861_);
            }
            p_187863_.m_196557_(p_187869_);
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_187869_));
    }, (p_196811_, p_196812_, p_196813_, p_196814_, p_196815_, p_196816_) -> {
        if (!p_196816_.m_6415_().m_62427_(p_196811_)) {
            if (p_196816_ instanceof ProtoChunk) {
                ProtoChunk protochunk = (ProtoChunk)p_196816_;
                protochunk.m_7150_(p_196811_);
            }
            p_196812_.m_196557_(p_196816_);
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_196816_));
    });
    public static final ChunkStatus f_62316_ = ChunkStatus.m_62414_("structure_references", f_62315_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_196843_, p_196844_, p_196845_, p_196846_, p_196847_) -> {
        WorldGenRegion worldgenregion = new WorldGenRegion(p_196844_, p_196846_, p_196843_, -1);
        p_196845_.m_62177_(worldgenregion, p_196844_.m_8595_().m_47272_(worldgenregion), p_196847_);
    });
    public static final ChunkStatus f_62317_ = ChunkStatus.m_62399_("biomes", f_62316_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_196832_, p_196833_, p_196834_, p_196835_, p_196836_, p_196837_, p_196838_, p_196839_, p_196840_, p_196841_) -> {
        if (!p_196841_ && p_196840_.m_6415_().m_62427_(p_196832_)) {
            return CompletableFuture.completedFuture(Either.left((Object)p_196840_));
        }
        WorldGenRegion worldgenregion = new WorldGenRegion(p_196834_, p_196839_, p_196832_, -1);
        return p_196835_.m_196423_(p_196834_.m_5962_().m_175515_(Registry.f_122885_), p_196833_, Blender.m_190202_((WorldGenRegion)worldgenregion), p_196834_.m_8595_().m_47272_(worldgenregion), p_196840_).thenApply(p_196819_ -> {
            if (p_196819_ instanceof ProtoChunk) {
                ((ProtoChunk)p_196819_).m_7150_(p_196832_);
            }
            return Either.left((Object)p_196819_);
        });
    });
    public static final ChunkStatus f_62318_ = ChunkStatus.m_62399_("noise", f_62317_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_196821_, p_196822_, p_196823_, p_196824_, p_196825_, p_196826_, p_196827_, p_196828_, p_196829_, p_196830_) -> {
        if (!p_196830_ && p_196829_.m_6415_().m_62427_(p_196821_)) {
            return CompletableFuture.completedFuture(Either.left((Object)p_196829_));
        }
        WorldGenRegion worldgenregion = new WorldGenRegion(p_196823_, p_196828_, p_196821_, 0);
        return p_196824_.m_183489_(p_196822_, Blender.m_190202_((WorldGenRegion)worldgenregion), p_196823_.m_8595_().m_47272_(worldgenregion), p_196829_).thenApply(p_196792_ -> {
            if (p_196792_ instanceof ProtoChunk) {
                ProtoChunk protochunk = (ProtoChunk)p_196792_;
                BelowZeroRetrogen belowzeroretrogen = protochunk.m_183376_();
                if (belowzeroretrogen != null) {
                    BelowZeroRetrogen.m_188474_((ProtoChunk)protochunk);
                    if (belowzeroretrogen.m_198220_()) {
                        belowzeroretrogen.m_198221_(protochunk);
                    }
                }
                protochunk.m_7150_(p_196821_);
            }
            return Either.left((Object)p_196792_);
        });
    });
    public static final ChunkStatus f_62319_ = ChunkStatus.m_62414_("surface", f_62318_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_156247_, p_156248_, p_156249_, p_156250_, p_156251_) -> {
        WorldGenRegion worldgenregion = new WorldGenRegion(p_156248_, p_156250_, p_156247_, 0);
        p_156249_.m_183621_(worldgenregion, p_156248_.m_8595_().m_47272_(worldgenregion), p_156251_);
    });
    public static final ChunkStatus f_62320_ = ChunkStatus.m_62414_("carvers", f_62319_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_187819_, p_187820_, p_187821_, p_187822_, p_187823_) -> {
        WorldGenRegion worldgenregion = new WorldGenRegion(p_187820_, p_187822_, p_187819_, 0);
        if (p_187823_ instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)p_187823_;
            Blender.m_197034_((WorldGenLevel)worldgenregion, (ProtoChunk)protochunk);
        }
        p_187821_.m_183516_(worldgenregion, p_187820_.m_7328_(), p_187820_.m_7062_(), p_187820_.m_8595_().m_47272_(worldgenregion), p_187823_, GenerationStep.Carving.AIR);
    });
    public static final ChunkStatus f_62321_ = ChunkStatus.m_62414_("liquid_carvers", f_62320_, 8, f_62328_, ChunkType.PROTOCHUNK, (p_196805_, p_196806_, p_196807_, p_196808_, p_196809_) -> {});
    public static final ChunkStatus f_62322_ = ChunkStatus.m_62399_("features", f_62321_, 8, f_62328_, ChunkType.PROTOCHUNK, (p_187808_, p_187809_, p_187810_, p_187811_, p_187812_, p_187813_, p_187814_, p_187815_, p_187816_, p_187817_) -> {
        ProtoChunk protochunk = (ProtoChunk)p_187816_;
        protochunk.m_63209_((LevelLightEngine)p_187813_);
        if (p_187817_ || !p_187816_.m_6415_().m_62427_(p_187808_)) {
            Heightmap.m_64256_((ChunkAccess)p_187816_, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
            WorldGenRegion worldgenregion = new WorldGenRegion(p_187810_, p_187815_, p_187808_, 1);
            p_187811_.m_183372_(worldgenregion, p_187816_, p_187810_.m_8595_().m_47272_(worldgenregion));
            Blender.m_197031_((WorldGenRegion)worldgenregion, (ChunkAccess)p_187816_);
            protochunk.m_7150_(p_187808_);
        }
        return CompletableFuture.completedFuture(Either.left((Object)p_187816_));
    });
    public static final ChunkStatus f_62323_ = ChunkStatus.m_62406_("light", f_62322_, 1, f_62328_, ChunkType.PROTOCHUNK, (p_196794_, p_196795_, p_196796_, p_196797_, p_196798_, p_196799_, p_196800_, p_196801_, p_196802_, p_196803_) -> ChunkStatus.m_62388_(p_196794_, p_196799_, p_196802_), (p_196784_, p_196785_, p_196786_, p_196787_, p_196788_, p_196789_) -> ChunkStatus.m_62388_(p_196784_, p_196787_, p_196789_));
    public static final ChunkStatus f_62324_ = ChunkStatus.m_62414_("spawn", f_62323_, 0, f_62328_, ChunkType.PROTOCHUNK, (p_187763_, p_187764_, p_187765_, p_187766_, p_187767_) -> {
        if (!p_187767_.m_187679_()) {
            p_187765_.m_6929_(new WorldGenRegion(p_187764_, p_187766_, p_187763_, -1));
        }
    });
    public static final ChunkStatus f_62325_ = ChunkStatus.m_62414_("heightmaps", f_62324_, 0, f_62328_, ChunkType.PROTOCHUNK, (p_196758_, p_196759_, p_196760_, p_196761_, p_196762_) -> {});
    public static final ChunkStatus f_62326_ = ChunkStatus.m_62406_("full", f_62325_, 0, f_62328_, ChunkType.LEVELCHUNK, (p_196771_, p_196772_, p_196773_, p_196774_, p_196775_, p_196776_, p_196777_, p_196778_, p_196779_, p_196780_) -> (CompletableFuture)p_196777_.apply(p_196779_), (p_196764_, p_196765_, p_196766_, p_196767_, p_196768_, p_196769_) -> (CompletableFuture)p_196768_.apply(p_196769_));
    private static final List<ChunkStatus> f_62330_ = ImmutableList.of((Object)((Object)f_62326_), (Object)((Object)f_62322_), (Object)((Object)f_62321_), (Object)((Object)f_62317_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object)((Object)f_62315_), (Object[])new ChunkStatus[0]);
    private static final IntList f_62331_ = (IntList)Util.m_137469_(new IntArrayList(ChunkStatus.m_62349_().size()), p_196782_ -> {
        int i = 0;
        for (int j = ChunkStatus.m_62349_().size() - 1; j >= 0; --j) {
            while (i + 1 < f_62330_.size() && j <= f_62330_.get(i + 1).m_62445_()) {
                ++i;
            }
            p_196782_.add(0, i);
        }
    });
    private final String f_62332_;
    private final int f_62333_;
    private final ChunkStatus f_62334_;
    private final GenerationTask f_62335_;
    private final LoadingTask f_62336_;
    private final int f_62337_;
    private final ChunkType f_62338_;
    private final EnumSet<Heightmap.Types> f_62339_;

    private static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_62388_(ChunkStatus p_62389_, ThreadedLevelLightEngine p_62390_, ChunkAccess p_62391_) {
        boolean flag = ChunkStatus.m_62392_(p_62389_, p_62391_);
        if (!p_62391_.m_6415_().m_62427_(p_62389_)) {
            ((ProtoChunk)p_62391_).m_7150_(p_62389_);
        }
        return p_62390_.m_9353_(p_62391_, flag).thenApply(Either::left);
    }

    private static ChunkStatus m_62414_(String p_62415_, @Nullable ChunkStatus p_62416_, int p_62417_, EnumSet<Heightmap.Types> p_62418_, ChunkType p_62419_, SimpleGenerationTask p_62420_) {
        return ChunkStatus.m_62399_(p_62415_, p_62416_, p_62417_, p_62418_, p_62419_, p_62420_);
    }

    private static ChunkStatus m_62399_(String p_62400_, @Nullable ChunkStatus p_62401_, int p_62402_, EnumSet<Heightmap.Types> p_62403_, ChunkType p_62404_, GenerationTask p_62405_) {
        return ChunkStatus.m_62406_(p_62400_, p_62401_, p_62402_, p_62403_, p_62404_, p_62405_, f_62329_);
    }

    private static ChunkStatus m_62406_(String p_62407_, @Nullable ChunkStatus p_62408_, int p_62409_, EnumSet<Heightmap.Types> p_62410_, ChunkType p_62411_, GenerationTask p_62412_, LoadingTask p_62413_) {
        return Registry.m_122961_(Registry.f_122833_, p_62407_, new ChunkStatus(p_62407_, p_62408_, p_62409_, p_62410_, p_62411_, p_62412_, p_62413_));
    }

    public static List<ChunkStatus> m_62349_() {
        ChunkStatus chunkstatus;
        ArrayList list = Lists.newArrayList();
        for (chunkstatus = f_62326_; chunkstatus.m_62482_() != chunkstatus; chunkstatus = chunkstatus.m_62482_()) {
            list.add(chunkstatus);
        }
        list.add(chunkstatus);
        Collections.reverse(list);
        return list;
    }

    private static boolean m_62392_(ChunkStatus p_62393_, ChunkAccess p_62394_) {
        return p_62394_.m_6415_().m_62427_(p_62393_) && p_62394_.m_6332_();
    }

    public static ChunkStatus m_156185_(int p_156186_) {
        if (p_156186_ >= f_62330_.size()) {
            return f_62314_;
        }
        return p_156186_ < 0 ? f_62326_ : f_62330_.get(p_156186_);
    }

    public static int m_62421_() {
        return f_62330_.size();
    }

    public static int m_62370_(ChunkStatus p_62371_) {
        return f_62331_.getInt(p_62371_.m_62445_());
    }

    public ChunkStatus(String p_62342_, @Nullable ChunkStatus p_62343_, int p_62344_, EnumSet<Heightmap.Types> p_62345_, ChunkType p_62346_, GenerationTask p_62347_, LoadingTask p_62348_) {
        this.f_62332_ = p_62342_;
        this.f_62334_ = p_62343_ == null ? this : p_62343_;
        this.f_62335_ = p_62347_;
        this.f_62336_ = p_62348_;
        this.f_62337_ = p_62344_;
        this.f_62338_ = p_62346_;
        this.f_62339_ = p_62345_;
        this.f_62333_ = p_62343_ == null ? 0 : p_62343_.m_62445_() + 1;
    }

    public int m_62445_() {
        return this.f_62333_;
    }

    public String m_62467_() {
        return this.f_62332_;
    }

    public ChunkStatus m_62482_() {
        return this.f_62334_;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_187788_(Executor p_187789_, ServerLevel p_187790_, ChunkGenerator p_187791_, StructureManager p_187792_, ThreadedLevelLightEngine p_187793_, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> p_187794_, List<ChunkAccess> p_187795_, boolean p_187796_) {
        ChunkAccess chunkaccess = p_187795_.get(p_187795_.size() / 2);
        ProfiledDuration profiledduration = JvmProfiler.f_185340_.m_183559_(chunkaccess.m_7697_(), p_187790_.m_46472_(), this.f_62332_);
        CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> completablefuture = this.f_62335_.m_183270_(this, p_187789_, p_187790_, p_187791_, p_187792_, p_187793_, p_187794_, p_187795_, chunkaccess, p_187796_);
        return profiledduration != null ? completablefuture.thenApply(p_196756_ -> {
            profiledduration.m_185413_();
            return p_196756_;
        }) : completablefuture;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_62364_(ServerLevel p_62365_, StructureManager p_62366_, ThreadedLevelLightEngine p_62367_, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> p_62368_, ChunkAccess p_62369_) {
        return this.f_62336_.m_62530_(this, p_62365_, p_62366_, p_62367_, p_62368_, p_62369_);
    }

    public int m_62488_() {
        return this.f_62337_;
    }

    public ChunkType m_62494_() {
        return this.f_62338_;
    }

    public static ChunkStatus m_62397_(String p_62398_) {
        return (ChunkStatus)((Object)Registry.f_122833_.m_7745_(ResourceLocation.m_135820_(p_62398_)));
    }

    public EnumSet<Heightmap.Types> m_62500_() {
        return this.f_62339_;
    }

    public boolean m_62427_(ChunkStatus p_62428_) {
        return this.m_62445_() >= p_62428_.m_62445_();
    }

    public String toString() {
        return Registry.f_122833_.m_7981_((Object)this).toString();
    }

    public static final class ChunkType
    extends Enum<ChunkType> {
        public static final /* enum */ ChunkType PROTOCHUNK = new ChunkType();
        public static final /* enum */ ChunkType LEVELCHUNK = new ChunkType();
        private static final /* synthetic */ ChunkType[] $VALUES;

        public static ChunkType[] values() {
            return (ChunkType[])$VALUES.clone();
        }

        public static ChunkType valueOf(String p_62520_) {
            return Enum.valueOf(ChunkType.class, p_62520_);
        }

        private static /* synthetic */ ChunkType[] m_156312_() {
            return new ChunkType[]{PROTOCHUNK, LEVELCHUNK};
        }

        static {
            $VALUES = ChunkType.m_156312_();
        }
    }

    static interface GenerationTask {
        public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_183270_(ChunkStatus var1, Executor var2, ServerLevel var3, ChunkGenerator var4, StructureManager var5, ThreadedLevelLightEngine var6, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> var7, List<ChunkAccess> var8, ChunkAccess var9, boolean var10);
    }

    static interface LoadingTask {
        public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_62530_(ChunkStatus var1, ServerLevel var2, StructureManager var3, ThreadedLevelLightEngine var4, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> var5, ChunkAccess var6);
    }

    static interface SimpleGenerationTask
    extends GenerationTask {
        @Override
        default public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_183270_(ChunkStatus p_187882_, Executor p_187883_, ServerLevel p_187884_, ChunkGenerator p_187885_, StructureManager p_187886_, ThreadedLevelLightEngine p_187887_, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> p_187888_, List<ChunkAccess> p_187889_, ChunkAccess p_187890_, boolean p_187891_) {
            if (p_187891_ || !p_187890_.m_6415_().m_62427_(p_187882_)) {
                this.m_156322_(p_187882_, p_187884_, p_187885_, p_187889_, p_187890_);
                if (p_187890_ instanceof ProtoChunk) {
                    ProtoChunk protochunk = (ProtoChunk)p_187890_;
                    protochunk.m_7150_(p_187882_);
                }
            }
            return CompletableFuture.completedFuture(Either.left((Object)p_187890_));
        }

        public void m_156322_(ChunkStatus var1, ServerLevel var2, ChunkGenerator var3, List<ChunkAccess> var4, ChunkAccess var5);
    }
}

